<?php

$this->pageTitle = 'Szczegóły zlecenia #'.$model->id . ' - ' . Yii::app()->name;

$this->breadcrumbs = array(
	'Zlecenia'=>array('admin'),
	'Szczegóły zlecenia #'.$model->id,
);
?>

<h1>Szczegóły zlecenia #<?php echo $model->id; ?></h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('update', array('id' => $model->id)) ?>">Aktualizuj</a>

<?php

$this->widget('zii.widgets.CDetailView', array(
	'data'=>$model,
	'attributes'=>array(
		'id',
		array(
			'name' => 'idDziedziny',
			'value' => $model->dziedzina->nazwa
		),
		array(
			'name'=>'poziom',
			'type'=>'raw',
			'value'=>$model->poziomStr,
		),
		'kategoria',
		array(
			'name'=>'czas',
			'type'=>'raw',
			'value'=>sprintf('%02d:%02d:%02d', (int)$model->czas/3600, (int)$model->czas/60, (int)$model->czas%60),
		),
		array(
			'name'=>'cena',
			'type'=>'raw',
			'value'=>number_format($model->cena,2,'.',' '),
		),
		array(
			'name'=>'kara',
			'type'=>'raw',
			'value'=>sprintf('%.2f%% (%s zł)', $model->kara, number_format($model->cena * $model->kara / 100,2,'.',' ')),
		),
		array(
			'name'=>'czyPrzetarg',
			'type'=>'raw',
			'value'=>$model->czyPrzetarg ? 'Tak' : 'Nie',
		),
		array(
			'name'=>'czyEgzamin',
			'type'=>'raw',
			'value'=>$model->czyEgzamin ? 'Tak' : 'Nie',
		),
		array(
			'name'=>'urlObrazka',
			'type'=>'raw',
			'value'=>!empty($model->urlObrazka)?'<img src="'. Yii::app()->baseUrl.'/'.$model->urlObrazka.'" />':'<span class="null">Nie ustawiony</span>',
		),
		'tresc',
		'jednostka',
		array(
			'label'=>'Odpowiedzi',
			'value'=>implode('<br />',$answers),
			'type'=>'raw',
		),
		array(
			'name' => 'jezyk',
			'value' => $model->jezyk=='en' ? 'Angielski' : null,
		),
		array(
			'name' => 'wylaczone',
			'value' => $model->wylaczone=='1' ? 'Tak' : 'Nie',
		)
	),
));

?>